/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.cim.client.pi;

import com.ibm.hsc.cim.client.HSCCIMClient;
import com.ibm.hsc.client.PIAddCageDataBean;
import com.ibm.hsc.client.PICageInfoDataBean;
import com.ibm.hsc.client.PIEnvInfoDataBean;
import com.ibm.hsc.client.PIFrameDataBean;
import com.ibm.hsc.client.PIHSCFrameClient;
import com.ibm.hsc.client.PILEDDataBean;
import com.ibm.hsc.common.exceptions.HSCException;
import com.ibm.hsc.common.exceptions.PIHscClientException;
import com.ibm.hsc.common.exceptions.PIHscExceptionUtils;
import com.ibm.hsc.common.util.ByteUtilities;
import com.ibm.hsc.common.util.HSCLogUtils;
import com.ibm.hsc.common.util.PIHscConstants;
import com.ibm.hsc.common.util.PIHscUtil;
import com.ibm.hsc.common.util.Trace;
import com.ibm.websm.diagnostics.IDebug;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;
import org.snia.wbem.cim.CIMDataType;
import org.snia.wbem.cim.CIMException;
import org.snia.wbem.cim.CIMInstance;
import org.snia.wbem.cim.CIMObjectPath;
import org.snia.wbem.cim.CIMProperty;
import org.snia.wbem.cim.CIMValue;
import org.snia.wbem.cim.UnsignedInt16;
import org.snia.wbem.cim.UnsignedInt32;
import org.snia.wbem.cim.UnsignedInt8;

public class PIHSCFrameCIMClient
extends HSCCIMClient
implements PIHSCFrameClient {
    private static final int DUMMY_FRAME = 4;
    private static final String NAME_SPACE = "root/ibmhscS1_0";
    public static final String MOF_NAME = "Name";
    public static final String MOF_CREATION_CLASS_NAME = "CreationClassName";
    public static final String MOF_USER_DEFINED_NAME = "UserDefinedName";
    public static final String MOF_FRAME_TYPE = "FrameType";
    public static final String MOF_FRAME_NUMBER = "FrameNumber";
    public static final String MOF_STATE = "State";
    public static final String MOF_PASSWORD_STATUS = "PasswordStatus";
    public static final String MOF_FSP_TARGET = "FSPTarget";
    public static final String MOF_METHOD_STARTACDL = "StartACDL";
    public static final String MOF_METHOD_GETACDLSTATUS = "GetACDLStatus";
    public static final String MOF_METHOD_SETFRAMENUMBER = "setFrameNumber";
    public static final String MOF_LOC_CODE = "FrameLocCode";
    public static final String MOF_DRAWER_LOC_CODE = "DrawerLocCode";
    public static final String MOF_LOC_CODE_LIST = "LocCodeList";
    private static final String LOCK_ACTION = "LockAction";
    private static final String LOCK_OWNER = "LockOwnership";
    private static final String DOMAIN_LOC_CODE = "DomainLocCode";
    private static final String OWNING_CEC_MTMS = "OwningCecMtms";
    private static final String CAGE_NAMES = "CageName";
    private static final String CEC_MTMS_ARR = "CecMtms";
    private static final String MOF_CHANGE_MASK = "ChangeMask";
    private static final String MOF_NEXT_KEYLOCK_POS = "NextKeylockPos";
    private static final String MOF_NEXT_IPL_SIDE = "NextIplSide";
    private static final String MOF_NEXT_FSPM_OS_IPL_MODE = "NextFspmOsIplMode";
    private static final String MOF_NEXT_IPL_SPEED = "NextIplSpeed";
    private static final String MOF_NEXT_IPL_SPEED_OVERRIDE = "NextIplSpeedOverride";
    private static final String MOF_NEXT_HYPERVISOR_IPL_STATE = "NextHypervisorIplState";
    private static final String MOF_NEXT_FSPM_LPAR_BOOT_MODE = "NextFspmLparBootMode";
    public static final String MOF_INDICATOR_STATE_LIST = "IndicatorStateList";
    protected static final String MOF_SET_IDENTIFY_INDICATOR_STATES = "SetIdentifyIndicatorStates";
    public static final String MOF_REQUEST_TYPE_LIST = "RequestTypeList";

    public static PIHSCFrameCIMClient createInstance(String string, String string2, boolean bl, String string3) throws PIHscClientException {
        try {
            CIMObjectPath cIMObjectPath = new CIMObjectPath("IBMHSC_Frame", string3);
            cIMObjectPath.addKey(MOF_CREATION_CLASS_NAME, new CIMValue((Object)"IBMHSC_Frame"));
            Enumeration enumeration = PIHscUtil.getCIMEnumInstances(string, cIMObjectPath, true);
            CIMObjectPath cIMObjectPath2 = null;
            CIMObjectPath cIMObjectPath3 = null;
            String string4 = null;
            while (enumeration != null && enumeration.hasMoreElements()) {
                CIMObjectPath cIMObjectPath4 = (CIMObjectPath)enumeration.nextElement();
                CIMValue cIMValue = null;
                cIMValue = PIHscUtil.getCIMAttribute(string, cIMObjectPath4, MOF_NAME);
                string4 = (String)cIMValue.getValue();
                if (string2.equals(string4)) {
                    cIMObjectPath3 = cIMObjectPath4;
                    if (bl) break;
                }
                if (bl || !string2.equals((String)(cIMValue = PIHscUtil.getCIMAttribute(string, cIMObjectPath4, MOF_USER_DEFINED_NAME)).getValue())) continue;
                cIMObjectPath2 = cIMObjectPath4;
                break;
            }
            if (cIMObjectPath2 == null && cIMObjectPath3 == null) {
                System.out.println("| FrameClient. user name and int name are null");
                if (IDebug.enabled) {
                    System.err.println("| FrameClient. user name and int name are null");
                }
                return null;
            }
            if (cIMObjectPath2 == null) {
                string4 = string2;
            } else {
                cIMObjectPath3 = cIMObjectPath2;
            }
            return new PIHSCFrameCIMClient(string, string4, cIMObjectPath3, string3);
        }
        catch (CIMException cIMException) {
            PIHscClientException pIHscClientException = PIHscExceptionUtils.convert(cIMException);
            if (pIHscClientException == null) {
                pIHscClientException = new PIHscClientException("7000", "CIMExceptionBundle", cIMException.getID(), null, cIMException);
            }
            throw pIHscClientException;
        }
    }

    public PIHSCFrameCIMClient(String string, String string2, CIMObjectPath cIMObjectPath, String string3) {
        super(string, null, string2, cIMObjectPath, string3);
    }

    public Hashtable getFrameAttributes() throws PIHscClientException {
        CIMValue cIMValue = null;
        CIMProperty cIMProperty = null;
        Vector vector = null;
        Vector<Integer> vector2 = new Vector<Integer>();
        try {
            CIMInstance cIMInstance = this.getCIMInstance();
            if (cIMInstance != null) {
                Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
                cIMProperty = cIMInstance.getProperty(MOF_NAME);
                if (cIMProperty != null && (cIMValue = cIMProperty.getValue()) != null) {
                    hashtable.put(MOF_NAME, (String)cIMValue.getValue());
                }
                hashtable.put("frameType_PROP", new Integer(4));
                hashtable.put("frameNumber_PROP", "");
                cIMProperty = cIMInstance.getProperty("PortNum");
                if (cIMProperty != null && (cIMValue = cIMProperty.getValue()) != null) {
                    vector = (Vector)cIMValue.getValue();
                    for (int i = 0; i < vector.size(); ++i) {
                        UnsignedInt32 unsignedInt32 = (UnsignedInt32)vector.elementAt(i);
                        vector2.add(new Integer(unsignedInt32.intValue()));
                    }
                    hashtable.put("portNumbers_PROP", vector2);
                }
                return hashtable;
            }
        }
        catch (HSCException hSCException) {
            throw new PIHscClientException("7000", "CIMExceptionBundle", "7000", null, hSCException);
        }
        return null;
    }

    public Hashtable getCECList() throws PIHscClientException {
        return new Hashtable();
    }

    public Hashtable setPassword(short s, String string, String string2) {
        Hashtable<String, UnsignedInt16> hashtable = new Hashtable<String, UnsignedInt16>();
        UnsignedInt8 unsignedInt8 = new UnsignedInt8(s);
        Vector<CIMProperty> vector = new Vector<CIMProperty>();
        Vector vector2 = new Vector();
        CIMValue cIMValue = new CIMValue((Object)unsignedInt8);
        vector.addElement(new CIMProperty("passwordToUpdate", cIMValue));
        cIMValue = new CIMValue((Object)string);
        vector.addElement(new CIMProperty("currentPassword", cIMValue));
        cIMValue = new CIMValue((Object)string2);
        vector.addElement(new CIMProperty("newPassword", cIMValue));
        try {
            PIHscUtil.invokeCIMMethod(this.mHostName, this.mObjectPath, "setPassword", vector, vector2);
            UnsignedInt16 unsignedInt16 = (UnsignedInt16)((CIMProperty)vector2.elementAt(0)).getValue().getValue();
            hashtable.put("returnCode", unsignedInt16);
        }
        catch (CIMException cIMException) {
            cIMException.printStackTrace();
        }
        return hashtable;
    }

    public Hashtable platformPassword(String string) {
        Hashtable<String, UnsignedInt16> hashtable = new Hashtable<String, UnsignedInt16>();
        Vector<CIMProperty> vector = new Vector<CIMProperty>();
        Vector vector2 = new Vector();
        CIMValue cIMValue = new CIMValue((Object)string);
        vector.addElement(new CIMProperty("password", cIMValue));
        try {
            PIHscUtil.invokeCIMMethod(this.mHostName, this.mObjectPath, "platformPassword", vector, vector2);
            UnsignedInt16 unsignedInt16 = (UnsignedInt16)((CIMProperty)vector2.elementAt(0)).getValue().getValue();
            hashtable.put("returnCode", unsignedInt16);
        }
        catch (CIMException cIMException) {
            cIMException.printStackTrace();
        }
        return hashtable;
    }

    public void rebuild() throws PIHscClientException {
        Vector<CIMProperty> vector = new Vector<CIMProperty>();
        Vector vector2 = new Vector();
        try {
            System.out.println("Calling CIM Method to perform rebuild");
            vector.add(new CIMProperty("closeType", new CIMValue((Object)new UnsignedInt8(0))));
            PIHscUtil.invokeCIMMethod(this.mHostName, this.mObjectPath, "RebuildCec", vector, vector2);
        }
        catch (CIMException cIMException) {
            PIHscClientException pIHscClientException = PIHscExceptionUtils.convert(cIMException);
            if (pIHscClientException == null) {
                pIHscClientException = new PIHscClientException("7000", "CIMExceptionBundle", cIMException.getID(), null, cIMException);
            }
            pIHscClientException.printStackTrace();
            throw pIHscClientException;
        }
    }

    public PIEnvInfoDataBean getEnvironmentalInfo() throws PIHscClientException {
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        Vector vector3 = new Vector();
        PIEnvInfoDataBean pIEnvInfoDataBean = new PIEnvInfoDataBean();
        try {
            PIHscUtil.invokeCIMMethod(this.mHostName, this.mObjectPath, "getEnvironmentalInfo", vector2, vector3);
            vector = (Vector)((CIMProperty)vector3.elementAt(0)).getValue().getValue();
            if (vector != null && vector.size() > 0) {
                pIEnvInfoDataBean.setVoltAB((String)vector.elementAt(0));
                pIEnvInfoDataBean.setVoltBC((String)vector.elementAt(1));
                pIEnvInfoDataBean.setVoltCA((String)vector.elementAt(2));
                pIEnvInfoDataBean.setAmpsA((String)vector.elementAt(3));
                pIEnvInfoDataBean.setAmpsB((String)vector.elementAt(4));
                pIEnvInfoDataBean.setAmpsC((String)vector.elementAt(5));
            }
        }
        catch (CIMException cIMException) {
            PIHscClientException pIHscClientException = PIHscExceptionUtils.convert(cIMException);
            HSCLogUtils.clientLog(cIMException, HSCLogUtils._FrameClassLogInfo);
            if (pIHscClientException == null) {
                pIHscClientException = new PIHscClientException("7000", "CIMExceptionBundle", cIMException.getID(), null, cIMException);
            }
            throw pIHscClientException;
        }
        return pIEnvInfoDataBean;
    }

    public Hashtable bpaLockAction(int n) throws PIHscClientException {
        Trace.trace("accmhscT", "PIHSCFrameCIMClient.bpaLockAction ->");
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        Vector<CIMProperty> vector = new Vector<CIMProperty>();
        Vector vector2 = new Vector();
        try {
            CIMValue cIMValue = new CIMValue((Object)new UnsignedInt8((short)n));
            vector.addElement(new CIMProperty(LOCK_ACTION, cIMValue));
            if (3 <= Trace.LEVEL) {
                Trace.trace("accmhscD", "invoking bpaLockAction.. ");
            }
            PIHscUtil.invokeCIMMethod(this.mHostName, this.mObjectPath, "BpaLockAction", vector, vector2);
            int n2 = ((UnsignedInt16)((CIMProperty)vector2.elementAt(0)).getValue().getValue()).intValue();
            Integer n3 = new Integer(n2);
            int n4 = ((UnsignedInt8)((CIMProperty)vector2.elementAt(1)).getValue().getValue()).intValue();
            Integer n5 = new Integer(n4);
            int n6 = ((UnsignedInt8)((CIMProperty)vector2.elementAt(2)).getValue().getValue()).intValue();
            Integer n7 = new Integer(n6);
            String string = (String)((CIMProperty)vector2.elementAt(3)).getValue().getValue();
            hashtable.put("ReturnCode", n3);
            hashtable.put("ErrorData", n5);
            hashtable.put(LOCK_OWNER, n7);
            hashtable.put("OwningEntryMtms", string);
        }
        catch (CIMException cIMException) {
            PIHscClientException pIHscClientException = PIHscExceptionUtils.convert(cIMException);
            HSCLogUtils.clientLog(cIMException, HSCLogUtils._FrameClassLogInfo);
            if (pIHscClientException == null) {
                pIHscClientException = new PIHscClientException("7000", "CIMExceptionBundle", cIMException.getID(), null, cIMException);
            }
            throw pIHscClientException;
        }
        if (2 <= Trace.LEVEL) {
            Trace.trace("accmhscF", "Hashtable returned: " + hashtable);
        }
        Trace.trace("accmhscT", "<- PIHSCFrameCIMClient.bpaLockAction");
        return hashtable;
    }

    public Hashtable bpaDisplayServiceEffect(String string) throws PIHscClientException {
        Trace.trace("accmhscT", "PIHSCFrameCIMClient.bpaDisplayServiceEffect ->");
        Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
        Vector<CIMProperty> vector = new Vector<CIMProperty>();
        Vector vector2 = new Vector();
        try {
            CIMValue cIMValue = new CIMValue((Object)new String(string));
            vector.addElement(new CIMProperty(DOMAIN_LOC_CODE, cIMValue));
            if (3 <= Trace.LEVEL) {
                Trace.trace("accmhscD", "invoking bpaDisplayServiceEffect... ");
            }
            PIHscUtil.invokeCIMMethod(this.mHostName, this.mObjectPath, "BpaDisplayServiceEffect", vector, vector2);
            int n = ((UnsignedInt16)((CIMProperty)vector2.elementAt(0)).getValue().getValue()).intValue();
            Integer n2 = new Integer(n);
            hashtable.put("ReturnCode", n2);
        }
        catch (CIMException cIMException) {
            PIHscClientException pIHscClientException = PIHscExceptionUtils.convert(cIMException);
            HSCLogUtils.clientLog(cIMException, HSCLogUtils._FrameClassLogInfo);
            if (pIHscClientException == null) {
                pIHscClientException = new PIHscClientException("7000", "CIMExceptionBundle", cIMException.getID(), null, cIMException);
            }
            throw pIHscClientException;
        }
        if (2 <= Trace.LEVEL) {
            Trace.trace("accmhscF", "Hashtable returned: " + hashtable);
        }
        Trace.trace("accmhscT", "<- PIHSCFrameCIMClient.bpaDisplayServiceEffect");
        return hashtable;
    }

    public Hashtable bpaFruLevelDeactivate(String string) throws PIHscClientException {
        Trace.trace("accmhscT", "PIHSCFrameCIMClient.bpaFruLevelDeactivate ->");
        Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
        Vector<CIMProperty> vector = new Vector<CIMProperty>();
        Vector vector2 = new Vector();
        try {
            CIMValue cIMValue = new CIMValue((Object)new String(string));
            vector.addElement(new CIMProperty(DOMAIN_LOC_CODE, cIMValue));
            if (3 <= Trace.LEVEL) {
                Trace.trace("accmhscD", "invoking bpaFruLevelDeactivate... ");
            }
            PIHscUtil.invokeCIMMethod(this.mHostName, this.mObjectPath, "BpaFruLevelDeactivate", vector, vector2);
            int n = ((UnsignedInt16)((CIMProperty)vector2.elementAt(0)).getValue().getValue()).intValue();
            Integer n2 = new Integer(n);
            hashtable.put("ReturnCode", n2);
            int n3 = ((UnsignedInt8)((CIMProperty)vector2.elementAt(1)).getValue().getValue()).intValue();
            Integer n4 = new Integer(n3);
            hashtable.put("ErrorData", n4);
        }
        catch (CIMException cIMException) {
            PIHscClientException pIHscClientException = PIHscExceptionUtils.convert(cIMException);
            HSCLogUtils.clientLog(cIMException, HSCLogUtils._FrameClassLogInfo);
            if (pIHscClientException == null) {
                pIHscClientException = new PIHscClientException("7000", "CIMExceptionBundle", cIMException.getID(), null, cIMException);
            }
            throw pIHscClientException;
        }
        if (2 <= Trace.LEVEL) {
            Trace.trace("accmhscF", "Hashtable returned: " + hashtable);
        }
        Trace.trace("accmhscT", "<- PIHSCFrameCIMClient.bpaFruLevelDeactivate");
        return hashtable;
    }

    public Hashtable bpaFruLevelDeactivateBySide(String string, String string2) throws PIHscClientException {
        Trace.trace("accmhscT", "PIHSCFrameCIMClient.bpaFruLevelDeactivate ->");
        Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
        Vector<CIMProperty> vector = new Vector<CIMProperty>();
        Vector vector2 = new Vector();
        try {
            CIMValue cIMValue = new CIMValue((Object)new String(string));
            vector.addElement(new CIMProperty(DOMAIN_LOC_CODE, cIMValue));
            CIMValue cIMValue2 = new CIMValue((Object)string2);
            vector.addElement(new CIMProperty("side", cIMValue2));
            if (3 <= Trace.LEVEL) {
                Trace.trace("accmhscD", "invoking bpaFruLevelDeactivateBySide... ");
            }
            PIHscUtil.invokeCIMMethod(this.mHostName, this.mObjectPath, "BpaFruLevelDeactivateBySide", vector, vector2);
            int n = ((UnsignedInt16)((CIMProperty)vector2.elementAt(0)).getValue().getValue()).intValue();
            Integer n2 = new Integer(n);
            hashtable.put("ReturnCode", n2);
            int n3 = ((UnsignedInt8)((CIMProperty)vector2.elementAt(1)).getValue().getValue()).intValue();
            Integer n4 = new Integer(n3);
            hashtable.put("ErrorData", n4);
        }
        catch (CIMException cIMException) {
            PIHscClientException pIHscClientException = PIHscExceptionUtils.convert(cIMException);
            HSCLogUtils.clientLog(cIMException, HSCLogUtils._FrameClassLogInfo);
            if (pIHscClientException == null) {
                pIHscClientException = new PIHscClientException("7000", "CIMExceptionBundle", cIMException.getID(), null, cIMException);
            }
            throw pIHscClientException;
        }
        if (2 <= Trace.LEVEL) {
            Trace.trace("accmhscF", "Hashtable returned: " + hashtable);
        }
        Trace.trace("accmhscT", "<- PIHSCFrameCIMClient.bpaFruLevelDeactivate");
        return hashtable;
    }

    public Hashtable bpaFruLevelActivate(String string) throws PIHscClientException {
        Trace.trace("accmhscT", "PIHSCFrameCIMClient.bpaFruLevelActivate ->");
        Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
        Vector<CIMProperty> vector = new Vector<CIMProperty>();
        Vector vector2 = new Vector();
        try {
            CIMValue cIMValue = new CIMValue((Object)new String(string));
            vector.addElement(new CIMProperty(DOMAIN_LOC_CODE, cIMValue));
            if (3 <= Trace.LEVEL) {
                Trace.trace("accmhscD", "invoking bpaFruLevelActivate... ");
            }
            PIHscUtil.invokeCIMMethod(this.mHostName, this.mObjectPath, "BpaFruLevelActivate", vector, vector2);
            int n = ((UnsignedInt16)((CIMProperty)vector2.elementAt(0)).getValue().getValue()).intValue();
            Integer n2 = new Integer(n);
            hashtable.put("ReturnCode", n2);
            int n3 = ((UnsignedInt8)((CIMProperty)vector2.elementAt(1)).getValue().getValue()).intValue();
            Integer n4 = new Integer(n3);
            hashtable.put("ErrorData", n4);
        }
        catch (CIMException cIMException) {
            PIHscClientException pIHscClientException = PIHscExceptionUtils.convert(cIMException);
            HSCLogUtils.clientLog(cIMException, HSCLogUtils._FrameClassLogInfo);
            if (pIHscClientException == null) {
                pIHscClientException = new PIHscClientException("7000", "CIMExceptionBundle", cIMException.getID(), null, cIMException);
            }
            throw pIHscClientException;
        }
        if (2 <= Trace.LEVEL) {
            Trace.trace("accmhscF", "Hashtable returned: " + hashtable);
        }
        Trace.trace("accmhscT", "<- PIHSCFrameCIMClient.bpaFruLevelActivate");
        return hashtable;
    }

    public PIFrameDataBean getFrameDataBean() throws PIHscClientException {
        return this.getFrameDataBean(PIFrameDataBean.ALL_KEYS);
    }

    public PIFrameDataBean getFrameDataBean(String[] stringArray) throws PIHscClientException {
        Object object;
        HashSet<String> hashSet = new HashSet<String>(stringArray.length * 2);
        for (int i = 0; i < stringArray.length; ++i) {
            hashSet.add(stringArray[i]);
        }
        CIMInstance cIMInstance = null;
        try {
            cIMInstance = PIHscUtil.getCIMInstance(this.mHostName, this.mObjectPath, false);
        }
        catch (CIMException cIMException) {
            cIMException.printStackTrace();
            throw PIHscExceptionUtils.convert(cIMException);
        }
        PIFrameDataBean pIFrameDataBean = new PIFrameDataBean();
        pIFrameDataBean.setInternalName((String)PIHscUtil.getCIMAttrValue(cIMInstance, MOF_NAME));
        if (hashSet.contains("name")) {
            pIFrameDataBean.setUserDefinedName((String)PIHscUtil.getCIMAttrValue(cIMInstance, MOF_USER_DEFINED_NAME));
        }
        if (hashSet.contains("frame_type")) {
            pIFrameDataBean.setFrameType((UnsignedInt8)PIHscUtil.getCIMAttrValue(cIMInstance, MOF_FRAME_TYPE));
        }
        if (hashSet.contains("frame_num")) {
            pIFrameDataBean.setFrameNumber((UnsignedInt16)PIHscUtil.getCIMAttrValue(cIMInstance, MOF_FRAME_NUMBER));
        }
        if (hashSet.contains("state")) {
            pIFrameDataBean.setState((UnsignedInt8)PIHscUtil.getCIMAttrValue(cIMInstance, MOF_STATE));
        }
        if (hashSet.contains("ipaddr_a") || hashSet.contains("ipaddr_b")) {
            this.getIpAddresses(pIFrameDataBean);
        }
        if (hashSet.contains("password_status")) {
            object = (UnsignedInt16)PIHscUtil.getCIMAttrValue(cIMInstance, MOF_PASSWORD_STATUS);
            short s = 0;
            if (object != null) {
                s = object.shortValue();
            }
            byte[] byArray = ByteUtilities.shortToByteArray(s);
            BitSet bitSet = ByteUtilities.byteArrayToBitSet(byArray);
            pIFrameDataBean.setPasswordStatus(bitSet);
        }
        if ((hashSet.contains("curr_power_on_side_a") || hashSet.contains("pend_power_on_side_a") || hashSet.contains("curr_power_on_side_b") || hashSet.contains("pend_power_on_side_b")) && (object = this.getSidesConnectionStatus()) != null && ((Hashtable)object).size() > 0) {
            UnsignedInt8[] unsignedInt8Array = null;
            if (((Hashtable)object).containsKey("SIDE_A") && (Integer)((Hashtable)object).get("SIDE_A") == 0) {
                this.debug("calling getFrameIplSide(a)");
                unsignedInt8Array = this.getFrameIplSide("SIDE_A");
                if (unsignedInt8Array != null && unsignedInt8Array.length == 2) {
                    int n = unsignedInt8Array[0].intValue();
                    this.debug("currValue=" + n);
                    if (0 == n || 1 == n) {
                        pIFrameDataBean.setPlatformCurrIplSideA(new UnsignedInt8((short)n));
                    }
                    int n2 = unsignedInt8Array[1].intValue();
                    this.debug("nextValue=" + n2);
                    if (0 == n2 || 1 == n2) {
                        pIFrameDataBean.setPlatformNextIplSideA(new UnsignedInt8((short)n2));
                    }
                }
            } else {
                pIFrameDataBean.setPlatformCurrIplSideA(null);
                pIFrameDataBean.setPlatformNextIplSideA(null);
            }
            if (((Hashtable)object).containsKey("SIDE_B") && (Integer)((Hashtable)object).get("SIDE_B") == 0) {
                this.debug("calling getFrameIplSide(b)");
                unsignedInt8Array = this.getFrameIplSide("SIDE_B");
                if (unsignedInt8Array != null && unsignedInt8Array.length == 2) {
                    int n;
                    int n3 = unsignedInt8Array[0].intValue();
                    if (0 == n3 || 1 == n3) {
                        pIFrameDataBean.setPlatformCurrIplSideB(new UnsignedInt8((short)n3));
                    }
                    if (0 == (n = unsignedInt8Array[1].intValue()) || 1 == n) {
                        pIFrameDataBean.setPlatformNextIplSideB(new UnsignedInt8((short)n));
                    }
                }
            } else {
                pIFrameDataBean.setPlatformCurrIplSideB(null);
                pIFrameDataBean.setPlatformNextIplSideB(null);
            }
        }
        return pIFrameDataBean;
    }

    private void getIpAddresses(PIFrameDataBean pIFrameDataBean) throws PIHscClientException {
        CIMInstance cIMInstance = null;
        Enumeration enumeration = null;
        try {
            enumeration = PIHscUtil.getCIMAssociationInst(this.mHostName, this.mObjectPath, "IBMHSC_FrameConnection", "IBMHSC_Connection", "GroupComponent", "PartComponent", true, true, null);
            Vector<String> vector = new Vector<String>();
            while (enumeration != null && enumeration.hasMoreElements()) {
                cIMInstance = (CIMInstance)enumeration.nextElement();
                String string = (String)PIHscUtil.getCIMAttrValue(cIMInstance, "LocationCode");
                String string2 = (String)PIHscUtil.getCIMAttrValue(cIMInstance, "IPAddress");
                if ("SIDE_A".equals(string)) {
                    pIFrameDataBean.setIpAddrA(string2);
                    continue;
                }
                if ("SIDE_B".equals(string)) {
                    pIFrameDataBean.setIpAddrB(string2);
                    continue;
                }
                vector.add(string2);
            }
            if (vector.size() > 0) {
                for (int i = 0; i < vector.size(); ++i) {
                    if (pIFrameDataBean.getIpAddrA() == null) {
                        pIFrameDataBean.setIpAddrA((String)vector.get(i));
                        continue;
                    }
                    pIFrameDataBean.setIpAddrB((String)vector.get(i));
                }
            }
        }
        catch (CIMException cIMException) {
            cIMException.printStackTrace();
            PIHscClientException pIHscClientException = PIHscExceptionUtils.convert(cIMException);
            if (pIHscClientException == null) {
                pIHscClientException = new PIHscClientException("7000", "CIMExceptionBundle", cIMException.getID(), null, cIMException);
            }
            throw pIHscClientException;
        }
    }

    private UnsignedInt8[] getFrameIplSide(String string) throws PIHscClientException {
        this.debug("in getFrameIplSide for " + string);
        try {
            Vector<CIMProperty> vector = new Vector<CIMProperty>();
            Vector vector2 = new Vector();
            CIMValue cIMValue = new CIMValue((Object)string, new CIMDataType(9));
            vector.addElement(new CIMProperty("side", cIMValue));
            UnsignedInt8[] unsignedInt8Array = new UnsignedInt8[2];
            PIHscUtil.invokeCIMMethod(this.mHostName, this.mObjectPath, "GetPlatformIplParameters", vector, vector2);
            if (vector2.elementAt(0) instanceof CIMValue) {
                unsignedInt8Array[0] = (UnsignedInt8)((CIMValue)vector2.elementAt(2)).getValue();
                unsignedInt8Array[1] = (UnsignedInt8)((CIMValue)vector2.elementAt(3)).getValue();
            } else {
                unsignedInt8Array[0] = (UnsignedInt8)((CIMProperty)vector2.elementAt(2)).getValue().getValue();
                unsignedInt8Array[1] = (UnsignedInt8)((CIMProperty)vector2.elementAt(3)).getValue().getValue();
            }
            this.debug("frameIplValues=" + unsignedInt8Array.toString());
            return unsignedInt8Array;
        }
        catch (CIMException cIMException) {
            cIMException.printStackTrace();
            PIHscClientException pIHscClientException = PIHscExceptionUtils.convert(cIMException);
            if (pIHscClientException == null) {
                pIHscClientException = new PIHscClientException("7000", "CIMExceptionBundle", cIMException.getID(), null, cIMException);
            }
            throw pIHscClientException;
        }
    }

    private void setFrameIplSide(UnsignedInt8 unsignedInt8, String string) throws PIHscClientException {
        this.debug("in setFrameIplSide(),nextIplSide=" + unsignedInt8.toString() + ", side=" + string);
        try {
            boolean bl = false;
            BitSet bitSet = PIHscConstants.IPLPARMS_CHANGEMASK;
            bitSet.clear();
            Vector<CIMProperty> vector = new Vector<CIMProperty>();
            Vector vector2 = new Vector();
            UnsignedInt8 unsignedInt82 = new UnsignedInt8(0);
            if (unsignedInt8 != null) {
                bitSet.set(29);
                bl = true;
            }
            UnsignedInt8 unsignedInt83 = new UnsignedInt8(0);
            UnsignedInt8 unsignedInt84 = new UnsignedInt8(0);
            UnsignedInt8 unsignedInt85 = new UnsignedInt8(0);
            UnsignedInt8 unsignedInt86 = new UnsignedInt8(0);
            UnsignedInt8 unsignedInt87 = new UnsignedInt8(0);
            if (bl) {
                UnsignedInt32 unsignedInt32 = ByteUtilities.bitSetToUnsignedInt32(bitSet);
                vector.addElement(new CIMProperty(MOF_CHANGE_MASK, new CIMValue((Object)unsignedInt32)));
                vector.addElement(new CIMProperty(MOF_NEXT_KEYLOCK_POS, new CIMValue((Object)unsignedInt82)));
                vector.addElement(new CIMProperty(MOF_NEXT_IPL_SIDE, new CIMValue((Object)unsignedInt8)));
                vector.addElement(new CIMProperty(MOF_NEXT_FSPM_OS_IPL_MODE, new CIMValue((Object)unsignedInt83)));
                vector.addElement(new CIMProperty(MOF_NEXT_IPL_SPEED, new CIMValue((Object)unsignedInt84)));
                vector.addElement(new CIMProperty(MOF_NEXT_IPL_SPEED_OVERRIDE, new CIMValue((Object)unsignedInt85)));
                vector.addElement(new CIMProperty(MOF_NEXT_HYPERVISOR_IPL_STATE, new CIMValue((Object)unsignedInt86)));
                vector.addElement(new CIMProperty(MOF_NEXT_FSPM_LPAR_BOOT_MODE, new CIMValue((Object)unsignedInt87)));
                vector.addElement(new CIMProperty("side", new CIMValue((Object)string)));
                this.debug("inParams=" + vector.toString());
                PIHscUtil.invokeCIMMethod(this.mHostName, this.mObjectPath, "SetPlatformIplParameters", vector, vector2);
            }
        }
        catch (CIMException cIMException) {
            PIHscClientException pIHscClientException = PIHscExceptionUtils.convert(cIMException);
            if (pIHscClientException == null) {
                pIHscClientException = new PIHscClientException("7000", "CIMExceptionBundle", cIMException.getID(), null, cIMException);
            }
            throw pIHscClientException;
        }
    }

    public void setFrameDataBean(PIFrameDataBean pIFrameDataBean) throws PIHscClientException {
        if (IDebug.enabled) {
            System.err.println("-> setFrameDataBean: " + pIFrameDataBean.toString());
        }
        String string = this.getHostName();
        String string2 = pIFrameDataBean.getUserDefinedName();
        String string3 = null;
        String string4 = null;
        UnsignedInt8 unsignedInt8 = pIFrameDataBean.getFrameType();
        UnsignedInt16 unsignedInt16 = pIFrameDataBean.getFrameNumber();
        UnsignedInt8 unsignedInt82 = pIFrameDataBean.getState();
        UnsignedInt8 unsignedInt83 = pIFrameDataBean.getPlatformNextIplSideA();
        UnsignedInt8 unsignedInt84 = pIFrameDataBean.getPlatformNextIplSideB();
        CIMObjectPath cIMObjectPath = null;
        CIMInstance cIMInstance = null;
        CIMProperty cIMProperty = null;
        Object var14_14 = null;
        UnsignedInt16 unsignedInt162 = null;
        UnsignedInt16 unsignedInt163 = null;
        try {
            cIMObjectPath = this.getObjectPath();
            cIMInstance = PIHscUtil.getCIMInstance(string, cIMObjectPath, false);
            string3 = (String)cIMInstance.getProperty(MOF_USER_DEFINED_NAME).getValue().getValue();
            if (string2 != null && string3 != null && !string2.trim().equals(string3.trim())) {
                string4 = string2;
            }
            if (unsignedInt16 != null && (unsignedInt162 = (UnsignedInt16)(cIMProperty = cIMInstance.getProperty(MOF_FRAME_NUMBER)).getValue().getValue()).intValue() != unsignedInt16.intValue()) {
                unsignedInt163 = unsignedInt16;
            }
            this.setFrameNumber(string4, unsignedInt163);
            Hashtable hashtable = this.getSidesConnectionStatus();
            if (hashtable != null) {
                if (hashtable.containsKey("SIDE_A") && unsignedInt83 != null && (Integer)hashtable.get("SIDE_A") == 0) {
                    this.debug("calling setFrameIplSide for side a");
                    this.setFrameIplSide(unsignedInt83, "SIDE_A");
                }
                if (hashtable.containsKey("SIDE_B") && unsignedInt84 != null && (Integer)hashtable.get("SIDE_B") == 0) {
                    this.debug("calling setFrameIplSide for side b");
                    this.setFrameIplSide(unsignedInt84, "SIDE_B");
                }
            }
        }
        catch (CIMException cIMException) {
            cIMException.printStackTrace();
            PIHscClientException pIHscClientException = PIHscExceptionUtils.convert(cIMException);
            if (pIHscClientException == null) {
                pIHscClientException = new PIHscClientException("7000", "CIMExceptionBundle", cIMException.getID(), null, cIMException);
            }
            throw pIHscClientException;
        }
        finally {
            if (IDebug.enabled) {
                System.err.println("<- setFrameDataBean");
            }
        }
    }

    public void setFrameNumber(String string, UnsignedInt16 unsignedInt16) throws PIHscClientException {
        this.debug("in setFrameNumber()");
        if (string != null || unsignedInt16 != null) {
            Object object;
            String string2;
            PICageInfoDataBean[] pICageInfoDataBeanArray = this.getFrameCageInfo();
            this.debug("PICageInfoDataBean[] instances=" + pICageInfoDataBeanArray.length);
            if (pICageInfoDataBeanArray != null && pICageInfoDataBeanArray.length > 0) {
                for (int i = 0; i < pICageInfoDataBeanArray.length; ++i) {
                    int n = pICageInfoDataBeanArray[i].getCageStatus();
                    string2 = pICageInfoDataBeanArray[i].getCageName();
                    object = ByteUtilities.intToByteArray(n);
                    BitSet bitSet = ByteUtilities.byteArrayToBitSet(object);
                    this.debug("cageStatusBitSet=" + bitSet.toString());
                    if (bitSet.get(1)) {
                        this.debug("Cage " + string2 + " is Powered On");
                        continue;
                    }
                    this.debug("Cage " + string2 + " is Powered Off");
                }
            }
            Vector<CIMProperty> vector = new Vector<CIMProperty>();
            Vector vector2 = new Vector();
            if (string == null || string.trim().length() == 0) {
                string = "$$Not$$Set$$";
            }
            if (unsignedInt16 == null) {
                unsignedInt16 = new UnsignedInt16(0);
            }
            string2 = new CIMValue((Object)unsignedInt16, new CIMDataType(3));
            object = new CIMValue((Object)string, new CIMDataType(9));
            vector.addElement(new CIMProperty(MOF_FRAME_NUMBER, (CIMValue)string2));
            vector.addElement(new CIMProperty(MOF_USER_DEFINED_NAME, (CIMValue)object));
            try {
                PIHscUtil.invokeCIMMethod(this.mHostName, this.mObjectPath, MOF_METHOD_SETFRAMENUMBER, vector, vector2);
            }
            catch (CIMException cIMException) {
                PIHscClientException pIHscClientException = PIHscExceptionUtils.convert(cIMException);
                HSCLogUtils.clientLog(cIMException, HSCLogUtils._FrameClassLogInfo);
                if (pIHscClientException == null) {
                    pIHscClientException = new PIHscClientException("7000", "CIMExceptionBundle", cIMException.getID(), null, cIMException);
                }
                throw pIHscClientException;
            }
        }
    }

    public Hashtable startACDL(String string) throws PIHscClientException {
        System.out.println("In frame client startACDL");
        Hashtable<String, Short> hashtable = new Hashtable<String, Short>();
        Vector<CIMProperty> vector = new Vector<CIMProperty>();
        Vector vector2 = new Vector();
        try {
            CIMValue cIMValue = new CIMValue((Object)new String(string));
            vector.addElement(new CIMProperty(MOF_FSP_TARGET, cIMValue));
            System.out.println("Invoking the cim provider");
            PIHscUtil.invokeCIMMethod(this.mHostName, this.mObjectPath, MOF_METHOD_STARTACDL, vector, vector2);
            System.out.println("After the invoke method");
            short s = ((UnsignedInt8)((CIMProperty)vector2.elementAt(0)).getValue().getValue()).shortValue();
            hashtable.put("ReturnCode", new Short(s));
            short s2 = ((UnsignedInt8)((CIMProperty)vector2.elementAt(1)).getValue().getValue()).shortValue();
            hashtable.put("ErrorData", new Short(s2));
        }
        catch (CIMException cIMException) {
            PIHscClientException pIHscClientException = PIHscExceptionUtils.convert(cIMException);
            HSCLogUtils.clientLog(cIMException, HSCLogUtils._FrameClassLogInfo);
            if (pIHscClientException == null) {
                pIHscClientException = new PIHscClientException("7000", "CIMExceptionBundle", cIMException.getID(), null, cIMException);
            }
            throw pIHscClientException;
        }
        return hashtable;
    }

    public Hashtable getACDLStatus(String string) throws PIHscClientException {
        System.out.println("In get ACDL status ");
        Hashtable<String, Serializable> hashtable = new Hashtable<String, Serializable>();
        Vector<CIMProperty> vector = new Vector<CIMProperty>();
        Vector vector2 = new Vector();
        try {
            CIMValue cIMValue = new CIMValue((Object)new String(string));
            vector.addElement(new CIMProperty(MOF_FSP_TARGET, cIMValue));
            System.out.println("Invoking the cim provider");
            PIHscUtil.invokeCIMMethod(this.mHostName, this.mObjectPath, MOF_METHOD_GETACDLSTATUS, vector, vector2);
            System.out.println("After the invoke method");
            short s = 0;
            s = ((UnsignedInt8)((CIMProperty)vector2.elementAt(0)).getValue().getValue()).shortValue();
            System.out.println("The value of temp data is :" + s);
            hashtable.put("ReturnCode", new Short(s));
            s = ((UnsignedInt8)((CIMProperty)vector2.elementAt(1)).getValue().getValue()).shortValue();
            System.out.println("The value of temp data is :" + s);
            hashtable.put("ErrorData", new Short(s));
            s = ((UnsignedInt8)((CIMProperty)vector2.elementAt(2)).getValue().getValue()).shortValue();
            System.out.println("The value of temp data is :" + s);
            hashtable.put("BPASide", new Short(s));
            s = ((UnsignedInt8)((CIMProperty)vector2.elementAt(3)).getValue().getValue()).shortValue();
            System.out.println("The value of temp data is :" + s);
            hashtable.put("SystemStatusMode", new Short(s));
            s = ((UnsignedInt8)((CIMProperty)vector2.elementAt(4)).getValue().getValue()).shortValue();
            System.out.println("The value of temp data is :" + s);
            hashtable.put("SystemStatusProgress", new Short(s));
            s = ((UnsignedInt8)((CIMProperty)vector2.elementAt(5)).getValue().getValue()).shortValue();
            System.out.println("The value of temp data is :" + s);
            hashtable.put("NoOfFRUCompleted", new Short(s));
            s = ((UnsignedInt8)((CIMProperty)vector2.elementAt(6)).getValue().getValue()).shortValue();
            System.out.println("The value of temp data is :" + s);
            hashtable.put("NoOfFRUToLoad", new Short(s));
            Vector vector3 = (Vector)((CIMProperty)vector2.elementAt(7)).getValue().getValue();
            hashtable.put("LocationCode", vector3);
            Vector vector4 = (Vector)((CIMProperty)vector2.elementAt(8)).getValue().getValue();
            hashtable.put("FruStatus", vector4);
            Vector vector5 = (Vector)((CIMProperty)vector2.elementAt(9)).getValue().getValue();
            hashtable.put("ActualCodeLevel1", vector5);
            Vector vector6 = (Vector)((CIMProperty)vector2.elementAt(10)).getValue().getValue();
            hashtable.put("ExpectedCodeLevel1", vector6);
            Vector vector7 = (Vector)((CIMProperty)vector2.elementAt(11)).getValue().getValue();
            hashtable.put("ActualCodeLevel2", vector7);
            Vector vector8 = (Vector)((CIMProperty)vector2.elementAt(12)).getValue().getValue();
            hashtable.put("ExpectedCodeLevel2", vector8);
        }
        catch (CIMException cIMException) {
            PIHscClientException pIHscClientException = PIHscExceptionUtils.convert(cIMException);
            HSCLogUtils.clientLog(cIMException, HSCLogUtils._FrameClassLogInfo);
            if (pIHscClientException == null) {
                pIHscClientException = new PIHscClientException("7000", "CIMExceptionBundle", cIMException.getID(), null, cIMException);
            }
            throw pIHscClientException;
        }
        return hashtable;
    }

    public Hashtable getSidesConnectionStatus() throws PIHscClientException {
        this.debug("in getSidesConnectionStatus()");
        CIMInstance cIMInstance = null;
        Enumeration enumeration = null;
        Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
        try {
            enumeration = PIHscUtil.getCIMAssociationInst(this.mHostName, this.mObjectPath, "IBMHSC_FrameConnection", "IBMHSC_Connection", "GroupComponent", "PartComponent", true, true, null);
            while (enumeration != null && enumeration.hasMoreElements()) {
                cIMInstance = (CIMInstance)enumeration.nextElement();
                String string = (String)PIHscUtil.getCIMAttrValue(cIMInstance, "LocationCode");
                int n = ((UnsignedInt16)PIHscUtil.getCIMAttrValue(cIMInstance, "ConnectionState")).intValue();
                hashtable.put(string, new Integer(n));
            }
            this.debug("connList=" + hashtable.toString());
            return hashtable;
        }
        catch (CIMException cIMException) {
            cIMException.printStackTrace();
            PIHscClientException pIHscClientException = PIHscExceptionUtils.convert(cIMException);
            if (pIHscClientException == null) {
                pIHscClientException = new PIHscClientException("7000", "CIMExceptionBundle", cIMException.getID(), null, cIMException);
            }
            throw pIHscClientException;
        }
    }

    public PICageInfoDataBean[] getFrameCageInfo() throws PIHscClientException {
        Object object;
        CIMInstance cIMInstance = null;
        Enumeration enumeration = null;
        ArrayList<PICageInfoDataBean> arrayList = new ArrayList<PICageInfoDataBean>();
        try {
            enumeration = PIHscUtil.getCIMAssociationInst(this.mHostName, this.mObjectPath, "IBMHSC_FrameCage", "IBMHSC_Cage", "GroupComponent", "PartComponent", true, true, null);
        }
        catch (CIMException cIMException) {
            cIMException.printStackTrace();
            PIHscClientException pIHscClientException = PIHscExceptionUtils.convert(cIMException);
            if (pIHscClientException == null) {
                pIHscClientException = new PIHscClientException("7000", "CIMExceptionBundle", cIMException.getID(), null, cIMException);
            }
            throw pIHscClientException;
        }
        while (enumeration != null && enumeration.hasMoreElements()) {
            cIMInstance = (CIMInstance)enumeration.nextElement();
            object = (String)PIHscUtil.getCIMAttrValue(cIMInstance, MOF_NAME);
            int n = ((UnsignedInt8)PIHscUtil.getCIMAttrValue(cIMInstance, "CageType")).intValue();
            int n2 = ((UnsignedInt16)PIHscUtil.getCIMAttrValue(cIMInstance, "CageStatus")).intValue();
            String string = (String)PIHscUtil.getCIMAttrValue(cIMInstance, "CageMtms");
            String string2 = (String)PIHscUtil.getCIMAttrValue(cIMInstance, "LocationCode");
            String string3 = (String)PIHscUtil.getCIMAttrValue(cIMInstance, "FrameTargetLocationCode");
            String string4 = (String)PIHscUtil.getCIMAttrValue(cIMInstance, "OwnerMtms");
            String string5 = (String)PIHscUtil.getCIMAttrValue(cIMInstance, "OwnerLocationCode");
            PICageInfoDataBean pICageInfoDataBean = new PICageInfoDataBean((String)object, n, n2, string, string2, string3, string4, string5);
            arrayList.add(pICageInfoDataBean);
        }
        try {
            Collections.sort(arrayList);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        object = arrayList.toArray(new PICageInfoDataBean[0]);
        return object;
    }

    public PIAddCageDataBean[] powerOnCage(Vector vector, Vector vector2) throws PIHscClientException {
        PIAddCageDataBean[] pIAddCageDataBeanArray;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        ArrayList<PIAddCageDataBean> arrayList = new ArrayList<PIAddCageDataBean>();
        Vector<CIMProperty> vector3 = new Vector<CIMProperty>();
        Vector vector4 = new Vector();
        CIMValue cIMValue = new CIMValue(vector, new CIMDataType(29));
        vector3.addElement(new CIMProperty(CAGE_NAMES, cIMValue));
        cIMValue = new CIMValue(vector2, new CIMDataType(29));
        vector3.addElement(new CIMProperty(CEC_MTMS_ARR, cIMValue));
        try {
            PIHscUtil.invokeCIMMethod(this.mHostName, this.mObjectPath, "PowerOnCage", vector3, vector4);
            pIAddCageDataBeanArray = (PIAddCageDataBean[])((CIMProperty)vector4.elementAt(0)).getValue().getValue();
            Vector vector5 = (Vector)((CIMProperty)vector4.elementAt(1)).getValue().getValue();
            Vector vector6 = (Vector)((CIMProperty)vector4.elementAt(2)).getValue().getValue();
            Vector vector7 = (Vector)((CIMProperty)vector4.elementAt(3)).getValue().getValue();
            Vector vector8 = (Vector)((CIMProperty)vector4.elementAt(4)).getValue().getValue();
            Vector vector9 = (Vector)((CIMProperty)vector4.elementAt(5)).getValue().getValue();
            for (int i = 0; i < pIAddCageDataBeanArray.size(); ++i) {
                bl = (Boolean)pIAddCageDataBeanArray.elementAt(i);
                bl2 = (Boolean)vector5.elementAt(i);
                bl3 = (Boolean)vector6.elementAt(i);
                int n = ((UnsignedInt8)vector7.elementAt(i)).intValue();
                int n2 = ((UnsignedInt16)vector8.elementAt(i)).intValue();
                int n3 = ((UnsignedInt8)vector9.elementAt(i)).intValue();
                PIAddCageDataBean pIAddCageDataBean = new PIAddCageDataBean(bl, bl2, bl3, n, n2, n3);
                arrayList.add(pIAddCageDataBean);
            }
        }
        catch (CIMException cIMException) {
            cIMException.printStackTrace();
            PIHscClientException pIHscClientException = PIHscExceptionUtils.convert(cIMException);
            HSCLogUtils.clientLog(cIMException, HSCLogUtils._FrameClassLogInfo);
            if (pIHscClientException == null) {
                pIHscClientException = new PIHscClientException("7000", "CIMExceptionBundle", cIMException.getID(), null, cIMException);
            }
            throw pIHscClientException;
        }
        pIAddCageDataBeanArray = arrayList.toArray(new PIAddCageDataBean[0]);
        return pIAddCageDataBeanArray;
    }

    public Hashtable addDrawer(String string) throws PIHscClientException {
        System.out.println("In add Drawer frame cim client");
        Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
        Vector<CIMProperty> vector = new Vector<CIMProperty>();
        Vector vector2 = new Vector();
        try {
            CIMValue cIMValue = new CIMValue((Object)new String(string));
            vector.addElement(new CIMProperty(MOF_LOC_CODE, cIMValue));
            System.out.println("Invoking the cim provider");
            PIHscUtil.invokeCIMMethod(this.mHostName, this.mObjectPath, "AddDrawer", vector, vector2);
            System.out.println("After the invoke method");
            int n = ((UnsignedInt16)((CIMProperty)vector2.elementAt(0)).getValue().getValue()).intValue();
            Integer n2 = new Integer(n);
            hashtable.put("ReturnCode", n2);
            int n3 = ((UnsignedInt8)((CIMProperty)vector2.elementAt(1)).getValue().getValue()).intValue();
            Integer n4 = new Integer(n3);
            hashtable.put("ErrorData", n4);
        }
        catch (CIMException cIMException) {
            cIMException.printStackTrace();
            PIHscClientException pIHscClientException = PIHscExceptionUtils.convert(cIMException);
            HSCLogUtils.clientLog(cIMException, HSCLogUtils._FrameClassLogInfo);
            if (pIHscClientException == null) {
                pIHscClientException = new PIHscClientException("7000", "CIMExceptionBundle", cIMException.getID(), null, cIMException);
            }
            throw pIHscClientException;
        }
        if (2 <= Trace.LEVEL) {
            Trace.trace("accmhscF", "Hashtable returned: " + hashtable);
        }
        Trace.trace("accmhscT", "<- PIHSCFrameCIMClient.addDrawer");
        return hashtable;
    }

    public Hashtable removeDrawer(String string) throws PIHscClientException {
        System.out.println("In remove Drawer frame cim client");
        Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
        Vector<CIMProperty> vector = new Vector<CIMProperty>();
        Vector vector2 = new Vector();
        try {
            CIMValue cIMValue = new CIMValue((Object)new String(string));
            vector.addElement(new CIMProperty(MOF_DRAWER_LOC_CODE, cIMValue));
            System.out.println("Invoking the cim provider");
            PIHscUtil.invokeCIMMethod(this.mHostName, this.mObjectPath, "RemoveDrawer", vector, vector2);
            System.out.println("After the invoke method");
            int n = ((UnsignedInt16)((CIMProperty)vector2.elementAt(0)).getValue().getValue()).intValue();
            Integer n2 = new Integer(n);
            hashtable.put("ReturnCode", n2);
            int n3 = ((UnsignedInt8)((CIMProperty)vector2.elementAt(1)).getValue().getValue()).intValue();
            Integer n4 = new Integer(n3);
            hashtable.put("ErrorData", n4);
        }
        catch (CIMException cIMException) {
            cIMException.printStackTrace();
            PIHscClientException pIHscClientException = PIHscExceptionUtils.convert(cIMException);
            HSCLogUtils.clientLog(cIMException, HSCLogUtils._FrameClassLogInfo);
            if (pIHscClientException == null) {
                pIHscClientException = new PIHscClientException("7000", "CIMExceptionBundle", cIMException.getID(), null, cIMException);
            }
            throw pIHscClientException;
        }
        if (2 <= Trace.LEVEL) {
            Trace.trace("accmhscF", "Hashtable returned: " + hashtable);
        }
        Trace.trace("accmhscT", "<- PIHSCFrameCIMClient.removeDrawer");
        return hashtable;
    }

    public void powerOffUnownedDrawers() throws PIHscClientException {
        System.err.println("In power off unowned drawers frame cim client");
        Hashtable hashtable = new Hashtable();
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        try {
            System.err.println("Invoking the cim provider for PowerOffUnownedCages ");
            PIHscUtil.invokeCIMMethod(this.mHostName, this.mObjectPath, "PowerOffUnownedCages", vector, vector2);
            System.err.println("After the invoke method");
        }
        catch (CIMException cIMException) {
            cIMException.printStackTrace();
            PIHscClientException pIHscClientException = PIHscExceptionUtils.convert(cIMException);
            HSCLogUtils.clientLog(cIMException, HSCLogUtils._FrameClassLogInfo);
            if (pIHscClientException == null) {
                pIHscClientException = new PIHscClientException("7000", "CIMExceptionBundle", cIMException.getID(), null, cIMException);
            }
            throw pIHscClientException;
        }
    }

    public Vector getAllLocationCodes() throws PIHscClientException {
        UnsignedInt8 unsignedInt8 = null;
        Object var2_2 = null;
        Vector vector = null;
        Vector vector2 = null;
        Vector vector3 = null;
        Vector vector4 = null;
        Vector vector5 = null;
        Vector vector6 = new Vector();
        Vector vector7 = new Vector();
        Vector<PILEDDataBean> vector8 = new Vector<PILEDDataBean>();
        System.out.println("GetAllLocCode called");
        try {
            PIHscUtil.invokeCIMMethod(this.mHostName, this.mObjectPath, "GetAllLocCodeInfo", vector6, vector7);
            if (vector7.elementAt(0) instanceof CIMValue) {
                vector3 = (Vector)((CIMValue)vector7.elementAt(0)).getValue();
                vector5 = (Vector)((CIMValue)vector7.elementAt(1)).getValue();
                vector4 = (Vector)((CIMValue)vector7.elementAt(2)).getValue();
                vector2 = (Vector)((CIMValue)vector7.elementAt(3)).getValue();
                vector = (Vector)((CIMValue)vector7.elementAt(4)).getValue();
            } else {
                vector3 = (Vector)((CIMProperty)vector7.elementAt(0)).getValue().getValue();
                vector5 = (Vector)((CIMProperty)vector7.elementAt(1)).getValue().getValue();
                vector4 = (Vector)((CIMProperty)vector7.elementAt(2)).getValue().getValue();
                vector2 = (Vector)((CIMProperty)vector7.elementAt(3)).getValue().getValue();
                vector = (Vector)((CIMProperty)vector7.elementAt(4)).getValue().getValue();
            }
            Integer n = null;
            Integer n2 = null;
            String string = null;
            String string2 = null;
            String string3 = null;
            Integer[] integerArray = null;
            Integer[] integerArray2 = null;
            String[] stringArray = null;
            String[] stringArray2 = null;
            String[] stringArray3 = null;
            PILEDDataBean pILEDDataBean = null;
            System.out.println("states SIZE = " + vector.size());
            for (int i = 0; i < vector.size(); ++i) {
                unsignedInt8 = (UnsignedInt8)vector.get(i);
                n = unsignedInt8 != null ? new Integer(unsignedInt8.intValue()) : new Integer(0);
                unsignedInt8 = (UnsignedInt8)vector2.get(i);
                n2 = unsignedInt8 != null ? new Integer(unsignedInt8.intValue()) : new Integer(0);
                string3 = (String)vector5.get(i);
                string2 = (String)vector4.get(i);
                string = (String)vector3.get(i);
                System.out.println("enclosure = " + string);
                System.out.println("locationCode = " + string3);
                System.out.println("state = " + n);
                integerArray = new Integer[1];
                integerArray2 = new Integer[1];
                stringArray3 = new String[1];
                stringArray2 = new String[1];
                stringArray = new String[1];
                integerArray[0] = n;
                integerArray2[0] = n2;
                stringArray3[0] = string3;
                stringArray2[0] = string2;
                stringArray[0] = string;
                pILEDDataBean = new PILEDDataBean();
                pILEDDataBean.setLocationCodes(stringArray3);
                pILEDDataBean.setCCINs(stringArray2);
                pILEDDataBean.setEnclosures(stringArray);
                pILEDDataBean.setLEDStates(integerArray);
                pILEDDataBean.setLEDStatus(integerArray2);
                vector8.add(pILEDDataBean);
            }
        }
        catch (CIMException cIMException) {
            cIMException.printStackTrace();
            PIHscClientException pIHscClientException = PIHscExceptionUtils.convert(cIMException);
            if (pIHscClientException == null) {
                pIHscClientException = new PIHscClientException("7000", "CIMExceptionBundle", cIMException.getID(), null, cIMException);
            }
            throw pIHscClientException;
        }
        return vector8;
    }

    public Vector getIdentifyLEDUnderEnclosure(String string) throws PIHscClientException {
        Vector<PILEDDataBean> vector = new Vector<PILEDDataBean>();
        PILEDDataBean pILEDDataBean = null;
        String[] stringArray = null;
        Vector vector2 = this.getAllLocationCodes();
        for (int i = 0; i < vector2.size(); ++i) {
            pILEDDataBean = (PILEDDataBean)vector2.get(i);
            stringArray = pILEDDataBean.getEnclosures();
            if (stringArray == null || !string.equals(stringArray[0])) continue;
            vector.add(pILEDDataBean);
        }
        return vector;
    }

    public void setIdentifyLEDs(String[] stringArray, Integer[] integerArray, Integer[] integerArray2) throws PIHscClientException {
        Vector<CIMProperty> vector = new Vector<CIMProperty>();
        Vector vector2 = new Vector();
        UnsignedInt8[] unsignedInt8Array = null;
        UnsignedInt8[] unsignedInt8Array2 = null;
        try {
            int n;
            unsignedInt8Array = new UnsignedInt8[integerArray.length];
            unsignedInt8Array2 = new UnsignedInt8[integerArray2.length];
            for (n = 0; n < unsignedInt8Array.length; ++n) {
                unsignedInt8Array[n] = new UnsignedInt8(integerArray[n].shortValue());
            }
            for (n = 0; n < unsignedInt8Array2.length; ++n) {
                unsignedInt8Array2[n] = new UnsignedInt8(integerArray2[n].shortValue());
            }
            vector.addElement(new CIMProperty(MOF_LOC_CODE_LIST, new CIMValue((Object)stringArray, new CIMDataType(29))));
            vector.addElement(new CIMProperty(MOF_INDICATOR_STATE_LIST, new CIMValue((Object)integerArray, new CIMDataType(21))));
            vector.addElement(new CIMProperty(MOF_REQUEST_TYPE_LIST, new CIMValue((Object)integerArray2, new CIMDataType(21))));
            PIHscUtil.invokeCIMMethod(this.mHostName, this.mObjectPath, MOF_SET_IDENTIFY_INDICATOR_STATES, vector, vector2);
        }
        catch (CIMException cIMException) {
            PIHscClientException pIHscClientException = PIHscExceptionUtils.convert(cIMException);
            if (pIHscClientException == null) {
                pIHscClientException = new PIHscClientException("7000", "CIMExceptionBundle", cIMException.getID(), null, cIMException);
            }
            throw pIHscClientException;
        }
    }

    public Vector getIdentifyLEDs(String[] stringArray) throws PIHscClientException {
        PILEDDataBean pILEDDataBean = null;
        Object var3_3 = null;
        UnsignedInt8 unsignedInt8 = null;
        Vector<CIMProperty> vector = new Vector<CIMProperty>();
        Vector vector2 = new Vector();
        Vector<PILEDDataBean> vector3 = new Vector<PILEDDataBean>();
        Vector vector4 = null;
        System.out.println("***********getIdentifyLEDs called");
        try {
            vector.addElement(new CIMProperty(MOF_LOC_CODE_LIST, new CIMValue((Object)stringArray, new CIMDataType(29))));
            PIHscUtil.invokeCIMMethod(this.mHostName, this.mObjectPath, "GetIdentifyIndicatorStates", vector, vector2);
            vector4 = vector2.elementAt(0) instanceof CIMValue ? (Vector)((CIMValue)vector2.elementAt(0)).getValue() : (Vector)((CIMProperty)vector2.elementAt(0)).getValue().getValue();
            for (int i = 0; i < stringArray.length; ++i) {
                pILEDDataBean = new PILEDDataBean();
                pILEDDataBean.setLocationCodes(new String[]{stringArray[i]});
                unsignedInt8 = (UnsignedInt8)vector4.get(i);
                if (unsignedInt8 != null) {
                    pILEDDataBean.setLEDStates(new Integer[]{new Integer(unsignedInt8.intValue())});
                }
                vector3.add(pILEDDataBean);
            }
        }
        catch (CIMException cIMException) {
            PIHscClientException pIHscClientException = PIHscExceptionUtils.convert(cIMException);
            if (pIHscClientException == null) {
                pIHscClientException = new PIHscClientException("7000", "CIMExceptionBundle", cIMException.getID(), null, cIMException);
            }
            throw pIHscClientException;
        }
        return vector3;
    }

    private void debug(String string) {
        if (IDebug.enabled) {
            System.err.println("| FrameClient." + string);
        }
    }
}

